CREATE OR REPLACE PACKAGE sim2_export_station_pkg IS
  -- Author  : KHENAS - taken from old export package
  -- Created : 11/16/00 4:04:26 PM
  -- Purpose : export station data from SIM to STORET
  -- Public variable declarations
  v_export_log_seq      NUMBER(10);
  v_cur_stawell_is_nbr  NUMBER(8);
  v_cur_staintvl_is_nbr NUMBER(8);
  v_cur_staigua_is_nbr  NUMBER(8);
  v_cur_stacsng_is_nbr  NUMBER(8);
  v_cur_station_is_nbr  NUMBER(8);
  v_cur_tsmalp_is_nbr   NUMBER(8);
  v_cur_tsmwell_is_nbr  NUMBER(8);
  v_cur_tsmigua_is_nbr  NUMBER(8);
  v_cur_tsmintvl_is_nbr NUMBER(8);
  v_cur_tsmcsng_is_nbr  NUMBER(8);
  v_single_user         NUMBER(1); -- Single user environment?
  -- Public function and procedure declarations
FUNCTION get_allowable_value(p_alval_seq IN NUMBER) RETURN VARCHAR2;
FUNCTION get_next_station_is_nbr (p_org_id IN VARCHAR2) RETURN NUMBER;
FUNCTION GET_UOM_IS_NBR (p_org_id IN VARCHAR2, p_uom_name IN VARCHAR2, p_chdef_is_number IN NUMBER) RETURN NUMBER;
  FUNCTION get_next_tsmalp_is_nbr(p_org_id IN VARCHAR2) RETURN NUMBER;
  PROCEDURE SIM2_EXPORT_STATIONS( p_imp_log_seq IN NUMBER, p_org_id IN VARCHAR2, p_export_test IN NUMBER);
  PROCEDURE WRITE_ERROR (p_export_seq IN NUMBER, p_desc IN VARCHAR2) ;
END sim2_export_station_pkg;
/
CREATE OR REPLACE PACKAGE BODY sim2_export_station_pkg IS
  -- Function and procedure implementations
FUNCTION CHECK_IMPORT_TYPE(p_imp_log_seq IN NUMBER) RETURN NUMBER IS
  v_import_type     VARCHAR2(30);
  CURSOR c_get_imp_type(p_imp_log_seq IN NUMBER) IS
    SELECT SID_TYPE FROM SIM_IMP_DEFS, SIM_IMP_CFG, SIM_IMPORT_LOG
      WHERE SICC_SID_SEQ = SID_SEQ AND SIL_SICC_SEQ = SICC_SEQ AND SIL_SEQ = p_imp_log_seq;
BEGIN
 -- v_org_id := NAME_IN('IMPSTAT.L_SICG_SIC_ORG_ID');
  OPEN c_get_imp_type(p_imp_log_seq);
  FETCH c_get_imp_type INTO v_import_type;
  CLOSE c_get_imp_type;
  IF v_import_type = 'GW STATIONS' THEN
   RETURN 1;
  ELSE
   RETURN 0;
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    RETURN 0;
END;
/***************************************************************************************/
FUNCTION GET_PRIMARY_TYPE(p_tsmvstc_is_number IN NUMBER,p_tsmvstc_org_id IN VARCHAR2) RETURN NUMBER IS
  v_primary_type     VARCHAR2(30);
  CURSOR c_station_primary_type (p_tsmvstc_is_number IN NUMBER,p_tsmvstc_org_id IN VARCHAR2) IS SELECT
        PRIMARY_TYPE_CD
        FROM TSMVSTC
        WHERE TSMVSTC_IS_NUMBER = p_tsmvstc_is_number AND
              TSMVSTC_ORG_ID    = p_tsmvstc_org_id;
BEGIN
  OPEN c_station_primary_type(p_tsmvstc_is_number,p_tsmvstc_org_id);
  FETCH c_station_primary_type INTO v_primary_type;
  CLOSE c_station_primary_type;
  IF v_primary_type = 'Well' THEN
   RETURN 1;
  ELSIF v_primary_type = 'Estuary' OR v_primary_type = 'Ocean' OR v_primary_type = 'Great Lake' THEN
   RETURN 2;
  ELSE
   RETURN 0;
  END IF;
EXCEPTION
  WHEN OTHERS THEN
    RETURN 0;
END;
/******************************************************************************************************/
FUNCTION get_method_or_datum(p_tsmmad_is_nbr IN NUMBER, p_tsmmad_org_id IN VARCHAR2) RETURN VARCHAR2 IS
  v_id_code           VARCHAR2(2);
  CURSOR c_get_id_code IS
    SELECT ID_CODE FROM TSMMAD WHERE TSMMAD_IS_NUMBER = p_tsmmad_is_nbr
    AND TSMMAD_ORG_ID = RPAD(p_tsmmad_org_id, 8);
BEGIN
  /* kms - get the id code for this method or datum using the foreign key in the station locations table */
  OPEN c_get_id_code;
  FETCH c_get_id_code INTO v_id_code;
    IF c_get_id_code%NOTFOUND THEN
      v_id_code := NULL;
    END IF;
  CLOSE c_get_id_code;
  RETURN v_id_code;
EXCEPTION
  WHEN OTHERS THEN
    RETURN NULL;
END get_method_or_datum;
/***************************************************************************************/
/******************************************************************************************************/
FUNCTION get_allowable_value(p_alval_seq IN NUMBER) RETURN VARCHAR2 IS
  v_item_name         VARCHAR2(80);
  CURSOR c_get_alval_name(p_alval_seq IN NUMBER) IS
    SELECT SIA_ITEM FROM SIM_IMP_ALLOW_VALUES WHERE SIA_SEQ = p_alval_seq;
BEGIN
  OPEN c_get_alval_name(p_alval_seq);
  FETCH c_get_alval_name INTO v_item_name;
    IF c_get_alval_name%NOTFOUND THEN
      v_item_name := NULL;
      sim2_export_pkg.write_error(v_export_log_seq, 'Could not find allowable value with sequence: '||p_alval_seq);
    END IF;
  CLOSE c_get_alval_name;
  RETURN v_item_name;
EXCEPTION
  WHEN OTHERS THEN
    sim2_export_pkg.write_error(v_export_log_seq, SQLERRM||' - getting allowable value sequence.');
  RETURN NULL;
END get_allowable_value;
/******************************************************************************************************/
/******************************************************************************************************/
FUNCTION get_next_well_is_number (p_org_id IN VARCHAR2) RETURN NUMBER IS
   v_next_well_is_nbr NUMBER(8);
BEGIN
 v_single_user := SIM2_EXPORT_PKG.check_single_user; -- Returns a 1 if it is a single user environment
   IF  v_cur_stawell_is_nbr IS NULL OR v_single_user = 0 THEN
   /* get the next avail is nbr to use */
      v_next_well_is_nbr := sim2_export_pkg.get_eisn_number('TSMWELL',p_org_id);
      v_cur_stawell_is_nbr := v_next_well_is_nbr ;
   ELSE
     v_next_well_is_nbr := v_cur_stawell_is_nbr  + 1;
     v_cur_stawell_is_nbr := v_next_well_is_nbr;
   END IF;
   RETURN v_next_well_is_nbr;
EXCEPTION
   WHEN OTHERS THEN
     sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' - in get next well is number.');
     RETURN NULL;
END get_next_well_is_number;
/******************************************************************************************************/
/******************************************************************************************************/
FUNCTION get_next_intvl_is_number (p_org_id IN VARCHAR2) RETURN NUMBER IS
   v_next_intvl_is_nbr NUMBER(8);
BEGIN
 v_single_user := SIM2_EXPORT_PKG.check_single_user; -- Returns a 1 if it is a single user environment
   IF  v_cur_staintvl_is_nbr IS NULL OR v_single_user = 0 THEN
   /* get the next avail is nbr to use */
      v_next_intvl_is_nbr := sim2_export_pkg.get_eisn_number('TSMINTVL',p_org_id);
      v_cur_staintvl_is_nbr := v_next_intvl_is_nbr ;
   ELSE
     v_next_intvl_is_nbr := v_cur_staintvl_is_nbr  + 1;
     v_cur_staintvl_is_nbr := v_next_intvl_is_nbr;
   END IF;
   RETURN v_next_intvl_is_nbr;
EXCEPTION
   WHEN OTHERS THEN
     sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' - in get next intvl is number.');
     RETURN NULL;
END get_next_intvl_is_number;
/******************************************************************************************************/
/******************************************************************************************************/
FUNCTION get_next_igua_is_number (p_org_id IN VARCHAR2) RETURN NUMBER IS
   v_next_igua_is_number NUMBER(8);
BEGIN
 v_single_user := SIM2_EXPORT_PKG.check_single_user; -- Returns a 1 if it is a single user environment
   IF  v_cur_staigua_is_nbr IS NULL OR v_single_user = 0 THEN
   /* get the next avail is nbr to use */
      v_next_igua_is_number := sim2_export_pkg.get_eisn_number('TSMIGUA',p_org_id);
      v_cur_staigua_is_nbr := v_next_igua_is_number ;
   ELSE
     v_next_igua_is_number := v_cur_staigua_is_nbr  + 1;
     v_cur_staigua_is_nbr := v_next_igua_is_number;
   END IF;
   RETURN v_next_igua_is_number;
EXCEPTION
   WHEN OTHERS THEN
     sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' - in get next igua is number.');
     RETURN NULL;
END get_next_igua_is_number;
/******************************************************************************************************/
/******************************************************************************************************/
FUNCTION GET_UOM_IS_NBR (p_org_id IN VARCHAR2, p_uom_name IN VARCHAR2, p_chdef_is_number IN NUMBER)
   RETURN NUMBER IS
   TYPE t_uom_record IS RECORD (
      uom_is_nbr        NUMBER(8),
      uom_name             VARCHAR2(10));
   v_uom_info              t_uom_record;
   e_unk_uom               EXCEPTION;
   e_uom_sp                EXCEPTION;
   CURSOR c_get_is_nbr (p_org_id IN VARCHAR2, p_uom_name IN VARCHAR2) IS
      SELECT TSRUOM_IS_NUMBER, SHORT_FORM_NAME FROM TSRUOM WHERE TSRUOM_ORG_ID = RPAD(p_org_id,8) AND
      UPPER(SHORT_FORM_NAME) = UPPER(RPAD(p_uom_name,10));
BEGIN
   OPEN c_get_is_nbr(p_org_id, p_uom_name);
   FETCH c_get_is_nbr INTO v_uom_info;
   IF c_get_is_nbr%NOTFOUND THEN
      v_uom_info.uom_is_nbr := NULL;
      RAISE e_unk_uom;
   ELSE
      IF v_uom_info.uom_name != p_uom_name THEN
         RAISE e_uom_sp;
      END IF;
   END IF;
   CLOSE c_get_is_nbr;
   RETURN v_uom_info.uom_is_nbr;
EXCEPTION
   WHEN e_unk_uom THEN
     sim2_export_pkg.WRITE_ERROR(v_export_log_seq, 'Unknown Unit of Measure: '||p_uom_name);
     RETURN v_uom_info.uom_is_nbr;
   WHEN e_uom_sp THEN
     sim2_export_pkg.WRITE_ERROR(v_export_log_seq, 'Fix uom spelling in TSRCHDEF - is_number:'||p_chdef_is_number||', unit of measure misspelled: '||p_uom_name);
     RETURN v_uom_info.uom_is_nbr;
END GET_UOM_IS_NBR;
/******************************************************************************************************/
/******************************************************************************************************/
FUNCTION get_next_station_is_nbr (p_org_id IN VARCHAR2) RETURN NUMBER IS
BEGIN
 v_single_user := SIM2_EXPORT_PKG.check_single_user; -- Returns a 1 if it is a single user environment
   IF v_cur_station_is_nbr IS NULL OR v_single_user = 0 THEN
     v_cur_station_is_nbr := sim2_export_pkg.get_eisn_number('TSMSTATN',p_org_id);
   ELSE
      v_cur_station_is_nbr := v_cur_station_is_nbr + 1;
   END IF;
   RETURN v_cur_station_is_nbr ;
END GET_NEXT_STATION_IS_NBR;
/******************************************************************************************************/
FUNCTION get_next_tsmalp_is_nbr(p_org_id IN VARCHAR2) RETURN NUMBER IS
BEGIN
 v_single_user := SIM2_EXPORT_PKG.check_single_user; -- Returns a 1 if it is a single user environment
   IF v_cur_tsmalp_is_nbr IS NULL OR v_single_user = 0 THEN
     v_cur_tsmalp_is_nbr := sim2_export_pkg.get_eisn_number('TSMALP',p_org_id);
   ELSE
      v_cur_tsmalp_is_nbr := v_cur_tsmalp_is_nbr + 1;
   END IF;
   RETURN v_cur_tsmalp_is_nbr ;
END get_next_tsmalp_is_nbr;
/************************************************************************************************/
/******************************************************************************************************/
FUNCTION get_next_tsmwell_is_nbr(p_org_id IN VARCHAR2) RETURN NUMBER IS
BEGIN
 v_single_user := SIM2_EXPORT_PKG.check_single_user; -- Returns a 1 if it is a single user environment
   IF v_cur_station_is_nbr IS NULL OR v_single_user = 0 THEN
     v_cur_station_is_nbr := sim2_export_pkg.get_eisn_number('TSMWELL',p_org_id);
   ELSE
      v_cur_station_is_nbr := v_cur_station_is_nbr + 1;
   END IF;
   RETURN v_cur_station_is_nbr ;
END get_next_tsmwell_is_nbr;
/************************************************************************************************/
PROCEDURE UPDATE_STATIONS_EISN_TABLE (p_tsmstatn_is_nbr IN NUMBER, p_tsmalp_is_nbr IN NUMBER,
                                      p_tsmwell_is_nbr IN NUMBER, p_tsmigua_is_nbr IN NUMBER,
                                      p_tsmintvl_is_nbr IN NUMBER, p_tsmcsng_is_nbr IN NUMBER,
                                      p_org_id IN VARCHAR2) IS
--PROCEDURE UPDATE_STATIONS_EISN_TABLE (p_tsmstatn_is_number IN NUMBER,p_tsmalp_is_number IN NUMBER,
 --                                     p_org_id IN VARCHAR2) IS
BEGIN
--      sim2_export_pkg.UPDATE_STATIONS_EISN_TABLE(p_tsmstatn_is_number,p_tsmalp_is_number,p_org_id);
 sim2_export_pkg.UPDATE_STATIONS_EISN_TABLE(p_tsmstatn_is_nbr, p_tsmalp_is_nbr,
                                      p_tsmwell_is_nbr, p_tsmigua_is_nbr,
                                      p_tsmintvl_is_nbr, p_tsmcsng_is_nbr,
                                      p_org_id);
END UPDATE_STATIONS_EISN_TABLE;
/******************************************************************************************************/
PROCEDURE WRITE_ERROR (p_export_seq IN NUMBER, p_desc IN VARCHAR2) IS
BEGIN
 INSERT INTO SIM_EXPORT_DETAILS (SED_SEQ , SED_SEL_SEQ, SED_DESC ) VALUES (
    SIM_EXPORT_DETAILS_SEQ.NEXTVAL, p_export_seq, p_desc);
 COMMIT;
END WRITE_ERROR;
/******************************************************************************************************/
PROCEDURE SIM2_EXPORT_STATIONS( p_imp_log_seq IN NUMBER, p_org_id IN VARCHAR2, p_export_test IN NUMBER) IS
   v_primary_type      NUMBER(1);
   v_check_import_type NUMBER(1);
   v_export_log_seq    NUMBER(10);
   v_station_is_nbr    NUMBER(8);
   v_tsmalp_is_nbr     NUMBER(8);
   v_export_test       NUMBER(10);
   v_status            VARCHAR2(9);
   v_elevation_unit    VARCHAR2(2) := NULL;
   v_well_is_number    NUMBER(8);
   v_csng_is_number    NUMBER(8);
   v_intvl_is_number   NUMBER(8);
   v_igua_is_number    NUMBER(8);
   v_well_use          VARCHAR2(30);
   v_geoun_org         VARCHAR2(8);
   v_elevation_method  VARCHAR2(2) := NULL;
   v_elevation_datum   VARCHAR2(12) := NULL;
   v_complete_flag     VARCHAR2(1) := 'Y';
   v_station_cnt       NUMBER(10) := 0;       /* ADDED SNG 4/18/01 */
   v_is_number NUMBER(8);
   CURSOR c_stations (p_org_id IN VARCHAR2, p_export_test IN NUMBER) IS SELECT
      STA_SEQ, STA_ID, STA_ORG_ID, STA_STATUS, STA_IS_NUMBER, STA_NAME,
      STA_ESTAB_DATE, STA_DESC,  STA_IMPORT_SEQ, STA_EXPORT_SEQ,
      STA_TSMVSTC_IS_NUMBER, STA_TSMVSTC_ORG_ID,STA_TSMORGAN_IS_NUMBER,
      STA_TSMORGAN_ORG_ID
      FROM  SIM_STATIONS
      WHERE RPAD(STA_ORG_ID,8) = RPAD(p_org_id,8)  AND
            STA_STATUS = 'A'
            AND ROWNUM <= p_export_test
            AND STA_IMPORT_SEQ = p_imp_log_seq;
   CURSOR c_station_locations (p_sta_seq IN NUMBER) IS SELECT
       STL_SEQ,  STL_STA_SEQ, STL_LAT_DEGREES,  STL_LAT_MINUTES, STL_LAT_SECONDS,  STL_LONG_DEGREES,
       STL_LONG_MINUTES,  STL_LONG_SECONDS,  STL_GPS_SCALE,
       STL_LAT_DEC_MINUTES, STL_LONG_DEC_MINUTES, STL_LAT_DIR, STL_LONG_DIR,
       STL_TSMRRR_IS_NUMBER,STL_TSMRRR_ORG_ID,STL_TSMFHU_IS_NUMBER,STL_TSMFHU_ORG_ID,
       STL_TSMGEOPA_IS_NUMBER,STL_TSMGEOPA_ORG_ID,STL_TSMMAD_IS_NUMBER,STL_TSMMAD_ORG_ID,STL_TSMMAD_DATUM,
       STL_TSMMAD_METHOD,STL_RF1,STL_RF3,STL_NRCS,STL_ELEVATION_MSR,STL_ELEVATION_UNIT_SEQ,
       STL_ELEV_METH_SEQ, STL_ELEV_DAT_SEQ
       FROM SIM_STATION_LOCATIONS
       WHERE  STL_STA_SEQ = p_sta_seq;
   CURSOR c_station_wells (p_sta_seq IN NUMBER) IS SELECT
       SSW_SSI_SEQ, SSW_SEQ,SSW_TOTAL_DEPTH_UNIT,SSW_STA_SEQ,SSW_WELL_NO,SSW_NAME,
       SSW_STATUS_SEQ,SSW_WELL_USE_SEQ,SSW_PRIMRY_USE_SEQ,SSW_USERID_CODE,SSW_TSMSTATN_ORG_ID,
       SSW_TOTAL_DEPTH,SSW_WELL_CONST_METH,SSW_DEPTH_OF_CASING,SSW_IS_NUMBER,SSW_ORG_ID,
       STA_ESTAB_DATE
       FROM SIM_STATION_WELLS,SIM_STATIONS
       WHERE SSW_STA_SEQ = p_sta_seq AND STA_SEQ  = SSW_STA_SEQ;
  CURSOR c_station_intervals (p_sta_seq IN NUMBER) IS SELECT
        SSI_SEQ,SSI_TSMGEOUN_ORG_ID,SSI_TSMGEOUN_CD,SSI_SSW_SEQ,SSI_GEOUN_NAME,SSI_INTVL_ORG_ID,
        SSI_START_DEPTH,SSI_STOP_DEPTH,SSI_TYPE_CODE,SSI_SSW_IS_NUMBER,SSI_SSW_ORG_ID,
        SSI_GEOUN_ORG,SSI_GEOUN_ORG_ID,SSI_DEPTH_UNIT,SSC_START_DEPTH,SSC_STOP_DEPTH,SSC_DEPTH_UNITS,
        SSC_SEQ
        FROM SIM_STATION_INTVL,SIM_STATION_CASING
        WHERE SSI_SSW_SEQ = p_sta_seq
        AND SSI_SSW_SEQ = SSC_SSW_SEQ;
  CURSOR c_station_csng (p_sta_seq IN NUMBER) IS SELECT
        SSC_TYPE_CODE, SSC_THICKNESS_MSR, SSC_THICKNESS_UNIT_CD, SSC_INSD_DIAMTR_MSR,
        SSC_INSD_DIAMTR_UNT_CD, SSC_D_USERID_CODE, SSC_LAST_UPD_TS, SSC_SEQ,
        SSC_SSW_SEQ, TSMINTVL_IS_NUMBER, TSMINTVL_ORG_ID, SSC_START_DEPTH,
        SSC_STOP_DEPTH, SSC_DEPTH_UNITS
        FROM SIM_STATION_CASING
        WHERE SSC_SSW_SEQ = p_sta_seq;
  CURSOR c_station_igua (p_sta_seq IN NUMBER) IS SELECT
        TSMIGUA_IS_NUMBER,SIG_OTH_GEO_UNIT_NM,TSMIGUA_ORG_ID,SIG_P_AQ_IND_CD,SIG_W_BEAR_IND_CD,
        SIG_USER_ID_CD,SIG_LAST_UPD_CD,SIG_TSM_INTVL_IS_NBR,SIG_TSM_INTVL_ORG_ID,SIG_GEOUN_CD,
        SIG_GEOUN_ORG_ID,SIG_SEQ,SIG_STA_SEQ
        FROM SIM_STATION_IGUA
        WHERE SIG_STA_SEQ = p_sta_seq;
BEGIN
    v_check_import_type := CHECK_IMPORT_TYPE(p_imp_log_seq);
  BEGIN
   /* set up export log */
         --sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' 1');
      v_export_log_seq := sim2_export_pkg.GET_EXPORT_LOG_SEQ;
      INSERT INTO sim_export_log (SEL_SEQ, SEL_EXPORTED_BY, SEL_EXPORTED_ON,
                                  SEL_FILENAME, SEL_ORG_ID, sel_export_type)
         VALUES (v_export_log_seq, USER, SYSDATE, 'Station Load '||p_imp_log_seq, p_org_id, 'S');
       COMMIT;
         --sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' 2a');
   EXCEPTION
      WHEN OTHERS THEN
         sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' - setting up export log record.');
   END;
   sim2_export_pkg.WRITE_ERROR(v_export_log_seq, 'Start at: '||to_char(sysdate,'HH24:MI:SS'));
   v_export_test := NVL(p_export_test, 1000000);
   FOR v_station IN c_stations (p_org_id, v_export_test) LOOP
   v_primary_type := GET_PRIMARY_TYPE(v_station.STA_TSMVSTC_IS_NUMBER,v_station.STA_TSMVSTC_ORG_ID);
     IF v_primary_type = 2 THEN
        v_complete_flag := 'N';
     ELSE
        v_complete_flag := 'Y';
     END IF;
      IF v_station.sta_desc IS NULL THEN
         v_station.sta_desc := v_station.sta_name;
      END IF;
      BEGIN
     v_station_is_nbr := get_next_station_is_nbr(p_org_id);
 --  v_is_number := get_next_station_is_nbr(p_org_id);
   --sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' station# '||v_station_cnt||' V_IS_# = '||V_IS_NUMBER);
         INSERT INTO TSMSTATN (
            TSMSTATN_IS_NUMBER,
            TSMSTATN_ORG_ID,
            IDENTIFICATION_CD,
            EPA_KEY_IDENTIFIER,
            NAME,
            ESTABLISHMENT_DATE,
            ZID_RELATION_CODE,
            INFLUENCE_AREA,
            DESCRIPTION_TEXT,
            TRAVEL_DIR_TXT,
            WATER_DEPTH,
            WATER_DEPTH_UNIT,
            ECOREGION_NAME,
            D_COMPLETE_FLAG,
            D_DELETE_FLAG,
            D_LAST_STN_UPDT_TS,
            D_USERID_CODE,
            D_LAST_UPDT_TS,
            TSMORGAN_IS_NUMBER,
            TSMVSTC_IS_NUMBER,
            TSMVSTC_ORG_ID)
         VALUES (
            v_station_is_nbr,                       -- v_station_is_nbr                   /* TSMSTATN_IS_NUMBER */,
            RPAD(p_org_id,8)                   /* TSMSTATN_ORG_ID */,
            RPAD(v_station.sta_id,15)          /* IDENTIFICATION_CD */,
            NULL                               /* EPA_KEY_IDENTIFIER */,
            v_station.STA_NAME                 /* NAME */,
            v_station.STA_ESTAB_DATE           /* ESTABLISHMENT_DATE */,
            NULL                               /* ZID_RELATION_CODE */,
            NULL                               /* INFLUENCE_AREA */,
            v_station.STA_DESC                 /* DESCRIPTION_TEXT */,
            NULL                               /* TRAVEL_DIR_TXT */,
            NULL                               /* WATER_DEPTH */,
            NULL                               /* WATER_DEPTH_UNIT */,
            NULL                               /* ECOREGION_NAME */,
            v_complete_flag                    /* D_COMPLETE_FLAG */,
            'N'                                /* D_DELETE_FLAG */,
            NULL                               /* D_LAST_STN_UPDT_TS */,
            USER                               /* D_USERID_CODE */,
            SYSDATE                            /* D_LAST_UPDT_TS */,
            v_station.STA_TSMORGAN_IS_NUMBER   /* TSMORGAN_IS_NUMBER */,
            v_station.STA_TSMVSTC_IS_NUMBER    /* TSMVSTC_IS_NUMBER */,
            RPAD(v_station.STA_TSMVSTC_ORG_ID,8)       /* TSMVSTC_ORG_ID */
            );
--   sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' end of station insert station # '||v_station_cnt);
    IF v_single_user = 0 THEN -- If it is a multi-user environment, commit after each insert
      sim2_export_pkg.UPDATE_TSMEISN(rpad(p_org_id,8),'TSMSTATN', v_station_is_nbr);
      COMMIT;
    END IF;
            v_station_cnt := v_station_cnt + 1;
            /* STATION LOCATIONS */
            FOR v_location in c_station_locations (v_station.sta_seq) LOOP
              /* kms - gets the method, datum, and units for elevation based on foreign keys in the
                 station locations table if elevation is present.  Otherwise, these are set to null */
              IF v_location.STL_ELEVATION_MSR IS NOT NULL THEN
                IF RPAD(p_org_id,8) = '21FLGW  ' THEN
                  v_elevation_method := 'MA';
                  v_elevation_datum  := 'SEALV';
                ELSE
                v_elevation_method  := get_allowable_value(v_location.STL_ELEV_METH_SEQ);
                v_elevation_datum   := get_allowable_value(v_location.STL_ELEV_DAT_SEQ);
                END IF;
                v_elevation_unit    := get_allowable_value(v_location.STL_ELEVATION_UNIT_SEQ);
                IF v_elevation_method IS NULL THEN
                  sim2_export_pkg.write_error(v_export_log_seq,'Station: '||v_station.sta_id||', did not retrieve elevation method code.');
                END IF;
                IF v_elevation_datum IS NULL THEN
                  sim2_export_pkg.write_error(v_export_log_seq,'Station: '||v_station.sta_id||', did not retrieve elevation datum code.');
                END IF;
              ELSE
                v_elevation_method  := NULL;    -- Manual Map Interpolation
                v_elevation_datum   := NULL;    -- Mean Sea Level
                v_elevation_unit    := NULL;    -- Elevation Unit
              END IF;
    BEGIN
          v_tsmalp_is_nbr := get_next_tsmalp_is_nbr(RPAD(p_org_id,8));
       INSERT INTO TSMALP (
          TSMALP_IS_NUMBER,
          TSMALP_ORG_ID,
          TYPE_CODE,
          SEQUENCE_NUMBER,
          ELEVATION_DATUM_CD,
          ELVTN_METHOD_CD,
          ELVTN_MSR_DT,
          ELEVATION_MSR,
          ELVTN_UNT_CD,
          GEOPSTNG_DATUM_CD,
          GEOPSTNG_METHOD_CD,
          GEOPSTNG_SCALE_TXT,
          LAT_DIRECTION,
          LAT_DEGREE_MSR,
          GPS_LAT_DEGREE_MSR,
          GPS_LAT_MINUTE_MSR,
          GPS_LONG_DEG_MSR,
          GPS_LONG_MIN_MSR,
          LAT_MINUTE_MSR,
          LAT_SECOND_MSR,
          LONG_DIRECTION,
          LONG_DEGREE_MSR,
          LONG_MINUTE_MSR,
          LONG_SECOND_MSR,
          LAT_LONG_MSR_DT,
          LATLONG_ACCRCY_MSR,
          LATLONG_ACCRCY_UNT,
          LONG_ACCRCY_MSR,
          LONG_ACCRCY_UNT_CD,
          RF3_RIVER_REACH_CD,
          RF1_MILEAGE,
          ON_RIVER_REACH_IND,
          NRCS_WTRSD_ID_NUM,
          D_USERID_CODE,
          D_LAST_UPDT_TS,
          TSMSTATN_ORG_ID,
          TSMSTATN_IS_NUMBER,
          TSMRRR_IS_NUMBER,
          TSMRRR_ORG_ID,
          TSMFHU_IS_NUMBER,
          TSMFHU_ORG_ID,
          TSMSTATN0IS_NUMBER,
          TSMSTATN0ORG_ID,
          TSMPIPE_IS_NUMBER,
          TSMPIPE_ORG_ID,
          TSMWELL_IS_NUMBER,
          TSMWELL_ORG_ID,
          TSMSTATN1ORG_ID,
          TSMSTATN1IS_NUMBER,
          TSMGEOPA_IS_NUMBER,
          TSMGEOPA_ORG_ID,
          TSMGEOPA0IS_NUMBER,
          TSMGEOPA0ORG_ID,
          TSMNAL_CD,
          TSMNAL_STATE,
          TSMNAL_ORG_ID
          )
       VALUES (
                     v_tsmalp_is_nbr                            /* TSMALP_IS_NUMBER */,
                     RPAD(p_org_id,8)                           /* TSMALP_ORG_ID */,
                     RPAD('*POINT OF RECORD',16)                /* TYPE_CODE */,
                     0                                          /* SEQUENCE_NUMBER */,
                     v_elevation_datum                          /* ELEVATION_DATUM_CD */,
                     v_elevation_method                         /* ELVTN_METHOD_CD */,
                     NULL, -- TO_DATE('01-JAN-99','DD-MON-RR')  /* ELVTN_MSR_DATE */,
                     TO_NUMBER(v_location.STL_ELEVATION_MSR)    /* ELEVATION_MSR */,
                     v_elevation_unit                           /* ELVTN_UNT_CD */,
                     RPAD(v_location.STL_TSMMAD_DATUM,5)        /* GEOPSTNG_DATUM_CD */,
                     RPAD(v_location.STL_TSMMAD_METHOD,2)       /* GEOPSTNG_METHOD_CD */,
                     v_location.STL_GPS_SCALE                   /* GEOPSTNG_SCALE_TXT */,
                     v_location.STL_LAT_DIR                     /* LAT_DIRECTION */,
                     v_location.STL_LAT_DEGREES                 /* LAT_DEGREE_MSR */,
                     v_location.STL_LAT_DEGREES                 /* GPS_LAT_DEGREE_MSR */,
                     v_location.STL_LAT_DEC_MINUTES             /* GPS_LAT_MINUTE_MSR */,
                     v_location.STL_LONG_DEGREES                /* GPS_LONG_DEG_MSR */,
                     v_location.STL_LONG_DEC_MINUTES            /* GPS_LONG_MIN_MSR */,
                     v_location.STL_LAT_MINUTES                 /* LAT_MINUTE_MSR */,
                     v_location.STL_LAT_SECONDS                 /* LAT_SECOND_MSR */,
                     v_location.STL_LONG_DIR                    /* LONG_DIRECTION */,
                     v_location.STL_LONG_DEGREES                /* LONG_DEGREE_MSR */,
                     v_location.STL_LONG_MINUTES                /* LONG_MINUTE_MSR */,
                     v_location.STL_LONG_SECONDS                /* LONG_SECOND_MSR */,
                     NULL,--TO_DATE('01-DEC-56','DD-MON-RR')    /* LAT_LONG_MSR_DT */,
                     NULL                                       /* LATLONG_ACCRCY_MSR */,
                     NULL                                       /* LATLONG_ACCRCY_UNT */,
                     NULL                                       /* LONG_ACCRCY_MSR */,
                     NULL                                       /* LONG_ACCRCY_UNT_CD */,
                     v_location.STL_RF3                         /* RF3_RIVER_REACH_CD */,
                     v_location.STL_RF1                         /* RF1_MILEAGE */,
                     NULL                                       /* ON_RIVER_REACH_IND */,
                     NULL                                       /* NRCS_WTRSD_ID_NUM */,
                     RPAD(USER,8)                               /* D_USERID_CODE */,
                     SYSDATE                                    /* D_LAST_UPDT_TS */,
                     NULL                                       /* TSMSTATN_ORG_ID */,
                     NULL                                       /* TSMSTATN_IS_NUMBER */,
--                   RPAD(v_station.STA_ORG_ID,8)               /* TSMSTATN_ORG_ID */,
--                    v_station.STA_IS_NUMBER                    /* TSMSTATN_IS_NUMBER */,                     
                     v_location.STL_TSMRRR_IS_NUMBER            /* TSMRRR_IS_NUMBER */,
                     RPAD(v_location.STL_TSMRRR_ORG_ID,8)       /* TSMRRR_ORG_ID */,
                     v_location.STL_TSMFHU_IS_NUMBER            /* TSMFHU_IS_NUMBER */,
                     RPAD(v_location.STL_TSMFHU_ORG_ID,8)       /* TSMFHU_ORG_ID */,
                     v_station_is_nbr                           /* TSMSTATN0IS_NUMBER */,
                     RPAD(p_org_id,8)                           /* TSMSTATN0ORG_ID */,
                     NULL                                       /* TSMPIPE_IS_NUMBER */,
                     NULL                                       /* TSMPIPE_ORG_ID */,
                     NULL                                       /* TSMWELL_IS_NUMBER */,
                     RPAD(p_org_id,8)                           /* TSMWELL_ORG_ID */,
                     RPAD(p_org_id,8)                           /* TSMSTATN1ORG_ID */,
                     NULL                                       /* TSMSTATN1IS_NUMBER */,
                     v_location.STL_TSMGEOPA_IS_NUMBER          /* TSMGEOPA_IS_NUMBER */,
                     RPAD(v_location.STL_TSMGEOPA_ORG_ID,8)     /* TSMGEOPA_ORG_ID */,
                     NULL,
                     NULL,
                     NULL                                       /*TSMNAL_CD */,
                     NULL                                       /*TSMNAL_STATE */,
                     NULL                                       /*TSMNAL_ORG_ID */
                    );
     IF v_single_user = 0 THEN -- If it is a multi-user environment, commit after each insert
      sim2_export_pkg.UPDATE_TSMEISN(rpad(p_org_id,8),'TSMALP', v_tsmalp_is_nbr);
      COMMIT;
    END IF;
               EXCEPTION
                  WHEN OTHERS THEN
                   sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM ||'exporting sta location');
               END;
            END LOOP;
 /* ADD WELL INFO */
--IF v_check_import_type = 1 AND v_primary_type = 1 THEN -- Only execute this code if it is a groundwater station of primary type Well
           FOR v_wells in c_station_wells (v_station.sta_seq) LOOP
v_well_use := get_allowable_value(v_wells.SSW_WELL_USE_SEQ);
v_status    := get_allowable_value(v_wells.SSW_STATUS_SEQ);
           v_well_is_number := get_next_well_is_number(RPAD(p_org_id,8));
               BEGIN
                  INSERT INTO TSMWELL (
                      TSMWELL_IS_NUMBER,
                      TSMWELL_ORG_ID,
                      NAME,
                      ID_NUMBER,
                      USE_CODE,
                      PRTCTN_AREA_NAME,
                      DEVELOPMNT_MTHD_CD,
                      CONSTRUCTN_MTHD_CD,
                      WTR_PRIMRY_USE_CD,
                      GRADIENT_TYPE_CODE,
                      DEPTH_CMPLTN_MSR,
                      DPTH_CMPLTN_UNT_CD,
                      DEPTH_OF_HOLE_MSR,
                      DEPTH_HOLE_UNT_CD,
                      WELL_HEAD_HT_MSR,
                      WL_HD_HT_UNIT_CD,
                      CASING_HGT_MSR,
                      CASING_HGT_UNIT_CD,
                      DISINFECTED_IND_CD,
                      CONSTRUCTN_STRT_DT,
                      CONSTRUCTN_END_DT,
                      INIT_PUMP_DUR,
                      INT_PMP_DUR_UNT_CD,
                      INIT_PUMP_RATE,
                      INT_PMP_RAT_UNT_CD,
                      NATURL_FLOW_IND_CD,
                      STATUS_CODE,
                      INIT_BOREHOLE_DIAM,
                      INIT_BHOLE_DIAM_UN,
                      D_USERID_CODE,
                      D_LAST_UPDT_TS,
                      TSMSTATN_IS_NUMBER,
                      TSMSTATN_ORG_ID)
                  VALUES (
                     v_well_is_number                          /* TSMWELL_IS_NUMBER */,
                     RPAD(p_org_id,8)                     /* TSMWELL_ORG_ID */,
                     RPAD(v_wells.SSW_NAME,40)            /* NAME */,
                     1,--v_wells.SSW_WELL_NO              /* ID NUMBER */,
                     RPAD(v_well_use,30)                  /* USE CODE */,
                     NULL                                 /* PROTECTION AREA NAME */,
                     NULL                                 /* DEVELOPMENT METHOD CD */,
                     v_wells.SSW_WELL_CONST_METH          /* CONSTRUCTION METHOD CD */,
                     NULL                                 /* WATER PRIMARY USE CODE */,
                     NULL                                 /* GRADIENT TYPE CD */,
                     v_wells.SSW_TOTAL_DEPTH              /* DEPTH AT COMPLETION */,
                     RPAD(v_wells.SSW_TOTAL_DEPTH_UNIT,2) /* DEPTH AT COMPLETION UNIT*/,
                     v_wells.SSW_DEPTH_OF_CASING          /* DEPTH OF HOLE MEASURE */,
                     RPAD(v_wells.SSW_TOTAL_DEPTH_UNIT,2) /* DEPTH OF HOLE UNIT CODE */,
                     NULL                                 /* WELL HEAD HEIGHT */,
                     NULL                                 /* WELL HEAD HEIGHT UNIT */,
                     NULL                                 /* CASING HEIGHT */,
                     NULL                                 /* CASING UNIT */,
                     NULL                                 /* DISINFECTED IND CD */,
                     v_wells.STA_ESTAB_DATE               /* CONSTRUCTION START DATE */,
                     NULL                                 /* CONSTRUCTION END DATE */,
                     NULL                                 /* INIT PUMP DUR */,
                     NULL                                 /* INT PUMP DUR UNT CD */,
                     NULL                                 /* INIT PUMP RATE */,
                     NULL                                 /* INIT PUMP RATE UNIT CD */,
                     NULL                                 /* NATURAL FLOW IND CD*/,
                     v_status                             /* STATUS CODE */,
                     NULL                                 /* INIT BOREHOLE DIA */,
                     NULL                                 /* INT BOREHOLE DIAM UN */,
                     RPAD(USER,8)                         /* D_USERID_CODE */,
                     SYSDATE                              /* D_LAST_UPDT_TS */,
                     v_station_is_nbr                     /* TSM STATION IS NUM */,
                     RPAD(p_org_id,8)                     /* TSMSTATN ORG ID */
                         );
    IF v_single_user = 0 THEN -- If it is a multi-user environment, commit after each insert
      sim2_export_pkg.UPDATE_TSMEISN(rpad(p_org_id,8),'TSMWELL', v_well_is_number);
      COMMIT;
    END IF;
                EXCEPTION
                  WHEN OTHERS THEN
                   sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM ||'exporting WELL location');
               END;
/* END ADD WELL INFO */
/* GEOLOGIC INTERVAL CODE */
/******************************/
           FOR v_intvl in c_station_intervals (v_station.sta_seq) LOOP
     IF v_intvl.SSI_TSMGEOUN_CD IS NOT NULL THEN
        v_geoun_org := 'ZZZZZZZZ';
     ELSE
         v_geoun_org := NULL;
     END IF;
IF  v_intvl.SSC_START_DEPTH IS NOT NULL THEN           /** TSMCSNG CASING TYPE IS NOT NULL (THERE IS A START DEPTH) **/
               BEGIN
 v_intvl_is_number := get_next_intvl_is_number(rpad(p_org_id,8));
                   INSERT INTO TSMINTVL (
                      TSMINTVL_IS_NUMBER /* TSMintvl_IS_NUMBER*/,
                      TSMINTVL_ORG_ID    /* TSMintvl_ORG_ID*/,
                      TYPE_CODE          /* OTH_GEO_UNIT_NM*/,
                      DEPTH_UNIT_CODE    /* SIG_P_AQ_IND_CD*/,
                      START_DEPTH_MSR    /* SIG_W_BEAR_IND_CD*/,
                      STOP_DEPTH_MSR     /* SIG_USER_ID_CD*/,
                      D_USERID_CODE      /* user id cd */,
                      D_LAST_UPDT_TS     /* SIG_LAST_UPD_CD*/,
                      TSMWELL_IS_NUMBER  /* TSMWELL IS NUMBER */,
                      TSMWELL_ORG_ID     /* TSMWELL ORG ID */,
                      TSMGEOUN_CD        /* SIG_GEOUN_CD*/,
                      TSMGEOUN_ORG_ID    /* SIG_GEOUN_ORG_ID*/
                      )
                 VALUES (
                      v_intvl_is_number                          /* TSMintvl_IS_NUMBER */,
                      RPAD(p_org_id,8)                     /* TSMWELL_ORG_ID */,
                      'CASING'                             /* TSMintvl GEOLOGIC UNIT */,
                      v_intvl.SSC_DEPTH_UNITS              /*depth measure */,
                      v_intvl.SSC_START_DEPTH              /* casing start depth */,
                      v_intvl.SSC_STOP_DEPTH               /* casing stop depth */,
                      RPAD(USER,8)                         /* D_USER_ID */,
                      SYSDATE                              /* D_LAST_UPD_TX */,
                      v_well_is_number                     /* TSM well - is NUMBER */,
                      RPAD(p_org_id,8)                     /* TSMWELL_ORG_ID */,
                      NULL                                 /* v_intvl.SSI_GEOUN_CD /* TSMintvl_GEOUN_CD */,
                      NULL                                 /* TSMGEOUN_ORG_ID */
                      );
    IF v_single_user = 0 THEN -- If it is a multi-user environment, commit after each insert
      sim2_export_pkg.UPDATE_TSMEISN(rpad(p_org_id,8),'TSMINTVL', v_intvl_is_number);
      COMMIT;
    END IF;
               EXCEPTION
                  WHEN OTHERS THEN
                   WRITE_ERROR(v_export_log_seq, SQLERRM ||' - exporting INTVL CASING location, station: '||v_station.sta_id);
      END;
END IF;
/* GEOLOGIC CASING CODE */
/******************************/
           FOR v_csng in c_station_csng (v_station.sta_seq) LOOP
IF  v_csng.SSC_TYPE_CODE IS NOT NULL THEN           /** TSMCSNG CASING TYPE IS NOT NULL **/
               BEGIN
-- v_csng_is_number := get_next_is_number(RPAD(p_org_id,8));
                  INSERT INTO TSMCSNG (
                      TSMINTVL_IS_NUMBER,
                      TSMINTVL_ORG_ID,
                      TYPE_CODE,
                      --THICKNESS_MSR,
                      --THICKNESS_UNT_CD,
                      INSD_DIAMTR_MSR,
                      INSD_DIAMTR_UNT_CD,
                      D_USERID_CODE,
                      D_LAST_UPDT_TS
                      )
                 VALUES (
                      v_intvl_is_number             /* TSMINTVL_IS_NUMBER */,
                      RPAD(p_org_id,8)               /* TSMINTVL_ORG_ID */,
                      v_csng.SSC_TYPE_CODE           /* TSMCSNG CASING TYPE*/,
                      --0                              /*thickness measure */,
                      --'in'                           /* thickness unit */,
                      v_csng.SSC_INSD_DIAMTR_MSR     /* CASING ID MEASURE*/,
                      v_csng. SSC_INSD_DIAMTR_UNT_CD /* INSIDE DIAMETER UNITS */,
                      RPAD(USER,8)                   /* D_USER_ID */,
                      SYSDATE                        /* D_LAST_UPD_TX */
                      );
    IF v_single_user = 0 THEN -- If it is a multi-user environment, commit after each insert
--      sim2_export_pkg.UPDATE_TSMEISN(rpad(p_org_id,8),'TSMCSNG', v_csng_is_number);
      COMMIT;
    END IF;
               EXCEPTION
                  WHEN OTHERS THEN
                   WRITE_ERROR(v_export_log_seq, SQLERRM ||'exporting CASING location');
               END;
END IF; -- If Casing Material is present
IF v_intvl.SSI_TSMGEOUN_CD IS NOT NULL THEN  -- IF THERE IS NO AQUIFER THEN DON'T DO THIS.
-- putting this below the begin v_intvl_is_number := get_next_intvl_is_number(v_intvl.SSI_SSW_ORG_ID);
      BEGIN
v_intvl_is_number := get_next_intvl_is_number(RPAD(p_org_id,8));
                   INSERT INTO TSMINTVL (
                      TSMINTVL_IS_NUMBER /* TSMintvl_IS_NUMBER*/,
                      TSMINTVL_ORG_ID    /* TSMintvl_ORG_ID*/,
                      TYPE_CODE          /* OTH_GEO_UNIT_NM*/,
                      DEPTH_UNIT_CODE    /* SIG_P_AQ_IND_CD*/,
                      START_DEPTH_MSR    /* SIG_W_BEAR_IND_CD*/,
                      STOP_DEPTH_MSR     /* SIG_USER_ID_CD*/,
                      D_USERID_CODE      /* user id cd */,
                      D_LAST_UPDT_TS     /* SIG_LAST_UPD_CD*/,
                      TSMWELL_IS_NUMBER  /* TSMWELL IS NUMBER */,
                      TSMWELL_ORG_ID     /* TSMWELL ORG ID */,
                      TSMGEOUN_CD        /* SIG_GEOUN_CD*/,
                      TSMGEOUN_ORG_ID    /* SIG_GEOUN_ORG_ID*/
                      )
                 VALUES (
                      v_intvl_is_number                    /* TSMintvl_IS_NUMBER */,
                      RPAD(p_org_id,8)                     /* TSMWELL_ORG_ID */,
                      'GEOLOGIC UNIT'                      /* TSMintvl GEOLOGIC UNIT */,
                      v_intvl.SSI_DEPTH_UNIT               /* depth measure Unit */,
                      v_intvl.SSI_START_DEPTH              /* start depth */,
                      v_intvl.SSI_STOP_DEPTH               /* casing stop depth */,
                      RPAD(USER,8)                         /* D_USER_ID */,
                      SYSDATE                              /* D_LAST_UPD_TX */,
                      v_well_is_number                     /* TSM well - is NUMBER */,
                      RPAD(p_org_id,8)                     /* TSMWELL_ORG_ID */,
                      v_intvl.SSI_TSMGEOUN_CD              /* v_intvl.SSI_GEOUN_CD /* TSMintvl_GEOUN_CD */,
                      'ZZZZZZZZ'                           /* TSMGEOUN_ORG_ID */
                      );
    IF v_single_user = 0 THEN -- If it is a multi-user environment, commit after each insert
      sim2_export_pkg.UPDATE_TSMEISN(rpad(p_org_id,8),'TSMINTVL', v_intvl_is_number);
      COMMIT;
    END IF;
               EXCEPTION
                  WHEN OTHERS THEN
                   WRITE_ERROR(v_export_log_seq, SQLERRM ||'exporting INTVL Geologic unit location');
           END;
    ELSE 
                           sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM ||'Null found exporting Aquifer type (USGS Name) station: '||v_station.sta_id);
     
END IF;
/* GEOLOGIC UNIT CODE */
          FOR v_igua in c_station_igua (v_station.sta_seq) LOOP
IF v_igua.SIG_GEOUN_CD  IS NOT NULL THEN -- Only do this part if there is an interval
               BEGIN
        v_igua_is_number := get_next_igua_is_number(RPAD(p_org_id,8));
                  INSERT INTO TSMIGUA (
                      TSMIGUA_IS_NUMBER   /* TSMIGUA_IS_NUMBER*/,
                      TSMIGUA_ORG_ID      /* TSMIGUA_ORG_ID*/,
                      OTH_GEO_UNIT_NM     /* OTH_GEO_UNIT_NM*/,
                      PRIM_AQUFR_IND_CD   /* SIG_P_AQ_IND_CD*/,
                      WATER_BEARING_IND   /* SIG_W_BEAR_IND_CD*/,
                      D_USERID_CODE       /* SIG_USER_ID_CD*/,
                      D_LAST_UPDATE_TS    /* SIG_LAST_UPD_CD*/,
                      TSMINTVL_IS_NUMBER  /* SIG_TSM_INTVL_IS_NBR*/,
                      TSMINTVL_ORG_ID     /* SIG_TSM_INTVL_ORG_ID*/,
                      TSMGEOUN_CD         /* SIG_GEOUN_CD*/,
                      TSMGEOUN_ORG_ID     /* SIG_GEOUN_ORG_ID*/
                      )
                 VALUES (
                      v_igua_is_number                   /* TSMIGUA_IS_NUMBER */,
                      RPAD(p_org_id,8)                   /* TSMWELL_ORG_ID */,
                      'None', --v_igua.SIG_OTH_GEO_UNIT_NM  /* TSMIGUA GEOLOGIC SECONDARY UNIT */,
                      'Y',--v_igua.SIG_P_AQ_IND_CD       /* prim aquifer */,
                      'Y',--v_igua.SIG_W_BEAR_IND_CD     /* w/bearingind */,
                      RPAD(USER,8)                       /* D_USERID_CODE */,
                      SYSDATE                            /* D_LAST_UPD_TX */,
                      v_intvl_is_number                  /* v_igua.SIG_TSM_INTVL_IS_NBR            /* TSM intvl - is NUMBER */,
                      RPAD(p_org_id,8)                   /* TSMintvl_ORG_ID */,
                      v_igua.SIG_GEOUN_CD                /* v_igua.SSI_GEOUN_CD /* TSMigua_GEOUN_CD */,
                      v_igua.SIG_GEOUN_ORG_ID            /* TSMGEOUN_ORG_ID */
                       );
    IF v_single_user = 0 THEN -- If it is a multi-user environment, commit after each insert
      sim2_export_pkg.UPDATE_TSMEISN(rpad(p_org_id,8),'TSMIGUA', v_igua_is_number);
      COMMIT;
    END IF;
               EXCEPTION
                  WHEN OTHERS THEN
                   WRITE_ERROR(v_export_log_seq, SQLERRM ||'exporting INTERVAL aquifer location');
               END;
END IF;
/* END OF GEOLOGIC UNIT CODE */
END LOOP; -- Geologic Unit (aquifer)
END LOOP; -- tsmintvl (geologic unit)
END LOOP; -- Casing interval
END LOOP; -- Well
/*******************************/
            /* update station with export seq */
            UPDATE SIM_STATIONS SET
            STA_EXPORT_SEQ = v_export_log_seq,
            STA_IS_NUMBER = v_station_is_nbr,
            STA_STATUS = 'E'
            WHERE
            STA_SEQ = v_station.sta_seq;
            COMMIT;
      EXCEPTION
         WHEN OTHERS THEN
         sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM ||' exporting sta');
      END;
 --  sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM||' at end of loop station # '||v_station_cnt);
   END LOOP;
   /* UPDATE TV_ORG :=HE EISN TABLE NEXT ID SEQUENCES */
 -- UPDATE_STATIONS_EISN_TABLE (v_station_is_nbr,v_tsmalp_is_nbr,P_ORG_ID);
  UPDATE_STATIONS_EISN_TABLE (v_station_is_nbr, v_tsmalp_is_nbr,
                                      v_well_is_number, v_igua_is_number,
                                      v_intvl_is_number, v_csng_is_number,
                                      p_org_id);
   /* update export log with count - added SNG 4/18/01*/
  UPDATE SIM_EXPORT_LOG SET SEL_ACTIVITY_CNT = v_station_cnt
  WHERE SEL_SEQ = v_export_log_seq;
  /* update the import log with export info
     SNG 4/16/01 - added DECREMENT of sil_rows_ready */
  UPDATE SIM_IMPORT_LOG SET
     SIL_EXPORTED_ON = SYSDATE,
     SIL_EXPORTED_BY = USER,
     SIL_ROWS_READY = SIL_ROWS_READY - v_station_cnt
  WHERE SIL_SEQ = P_IMP_LOG_SEQ;
  /* Commented out SNG 4/18/01 and replaced with above statement
  UPDATE SIM_IMPORT_LOG SET SIL_EXPORTED_ON = SYSDATE
  WHERE SIL_SEQ = P_IMP_LOG_SEQ;
  UPDATE SIM_IMPORT_LOG SET SIL_EXPORTED_BY = USER
  WHERE SIL_SEQ = P_IMP_LOG_SEQ;
  */
   /* all done! */
   sim2_export_pkg.WRITE_ERROR(v_export_log_seq, 'Finish at: '||to_char(sysdate,'HH24:MI:SS'));
   COMMIT;
EXCEPTION
  WHEN OTHERS THEN
  sim2_export_pkg.WRITE_ERROR(v_export_log_seq, SQLERRM ||'IN sim2 export stations');
END SIM2_EXPORT_STATIONS;
/******************************************************************************************************/
END sim2_export_station_pkg;
/
